function [cwquant, totale, pi, fisher] = fishagg_jgf(real, nomin, price, basestart, quarterly);


% Fisher/Chain Aggregation
%
% [cwquant, totale, pi, fisher] = fishagg(real, nomin, price, basestart, quarterly);
%
% This program is a Matlab version of Macroadviser's Eviews prg fisheragg2().
% It scales the aggregate index to equal the average of the nominal
% quanitity of the aggregate in the base year.
%
% Input args
% real = matrix of real quantities of the elementals
% nomin = matrix of nominal quantities
% price = matrix of prices
% bseries = column vector of some base year defintion series (chained).
% basestart = start of "normalization" period
% quarterly = 0 for annual, 4 for quarterly.  Will determine how many rows get averaged for normalization
% 
% Output args
% cwquant = chain-weighted aggregate
% totale = nominal expenditure
% pi = price inddex
% fisher = fisher index
% ..version 11/24/2004, modified by John F 1/15/2014


%% 2/2017  JOHN NEEDS TO FIX -- IT APPEARS TO MATTER WHETHER WE DO THIS WITH REAL*PRICE = NOMIN. USING SCALED/NORMALIZED PRICES MESSES THIS UP,
% IT APPEARS. I discover this in doing the industry calculations. To reason to have separate is
% that you might sometimes want to use nomin...other times price.  But they need to be the
% same...
% Quick fix
price_in = price; % to save it
price = nomin./real;


%%

baseend = basestart+quarterly;

% Get the total number of series to include in your Fisher Index
[r,c] = size(price); %r=# of dates, c=# of elementals you want aggregated
% Calculate the Fisher Index
% Both Laspeyres and Paasche growth factors go from subsequent quarter 
% after first quarter of data to end.

% Laspeyres growth factor, uses period t-1 prices as weights
% Numerator
lnum = zeros(r-1,1); %initialize to zero
for i=1:c;
    %inner product of lagged price and current quantity 
    lnum = lnum + real(2:end, i).*price(1:end-1, i);
end %for
% Denominator
% calculate total expenditure (p*q), sum across elementals
% realQ*price = nominalQ
totale = zeros(r,1);
for i=1:c;
    totale = totale + nomin(:, i);
end
% the laspeyres growth factor for each year 
lasp = lnum./totale(1:end-1); %lagged total expenditure Pt-1*Qt-l

% Paasche growth factor, uses period t prices as weights
% Denominator
pdenom = zeros(r-1,1); %initialize to zero
for i=1:c;
    %inner product of current price and lagged quantity
    pdenom = pdenom + price(2:end,i).*real(1:end-1,i);
end
% Numerator is just the total expenditure (non-lagged)
% the paasche growth factor for each year
paasc = totale(2:end)./pdenom; 

% Fisher growth factor
% sqrt(laspeyres*paasche)
fisher = sqrt(lasp.*paasc);

% Calculate Fisher Aggregates
% First grow by the fisher growth rate, i.e. calc unscaled index
cwquant = zeros(r, 1);
cwquant(1) = 1; %set index number to 1 in first year
for i=2:r;
    cwquant(i) = cwquant(i-1)*fisher(i-1);
end

% This method scales the chain-weighted index equal to the average
% of the real/nominal series in the base year.
% Find the average of nominal series in base year
% Base year is set to 2000 with data starting in 1967.1
basetot = mean(totale(basestart:baseend));
% Find the average level of the unscaled index in the base year
xbase = mean(cwquant(basestart:baseend));

cwquant = (cwquant/xbase)*basetot;

% price index
 pi = (totale./cwquant)*100;
 pbase = mean(pi(basestart:baseend));
 pi = (pi/pbase)*100;
